<?php
header('Content-Type: application/json');

$mobile_number = isset($_REQUEST['mobile_number']) ? $_REQUEST['mobile_number'] : '';
$message = isset($_REQUEST['message']) ? $_REQUEST['message'] : '';
$branch_id = isset($_REQUEST['branch_id']) ? $_REQUEST['branch_id'] : '';

if (empty($mobile_number) || empty($message) || empty($branch_id)) {
    echo json_encode(['success' => false, 'error' => 'Missing mobile_number, message, or branch_id']);
    exit;
}

try {
    $db = new PDO('sqlite:smslab_config.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $stmt = $db->prepare("SELECT api_key, device_id FROM configs WHERE branch_id = ?");
    $stmt->execute([$branch_id]);
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
    exit;
}

if (!$config) {
    echo json_encode(['success' => false, 'error' => 'Invalid branch_id']);
    exit;
}

$api_url = 'https://sms.grwebdevs.com/api/v1/sms/send';
$api_key = $config['api_key'];
$device_id = $config['device_id'];

$parameters = [
    'mobile_number' => $mobile_number,
    'message'       => $message,
    'device'        => $device_id
];

$headers = [
    'apikey: ' . $api_key
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($parameters));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$result = curl_exec($ch);

if ($result === false) {
    echo json_encode(['success' => false, 'error' => 'cURL error: ' . curl_error($ch)]);
} else {
    echo $result;
}

curl_close($ch);
?>